// Autor: Marin Tomic

#include <cstdio>
#include <cstring>
#include <cassert>
#include <iostream>
#include <algorithm>

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR (i, 0, n)
#define _ << " _ " <<
#define TRACE(x) cerr << #x << " = " << x << endl
#define debug(...) fprintf(stderr, __VA_ARGS__)

// #define TRACE(x)
// #define debug(...)

using namespace std;

typedef long long llint;

const int MAXN = 110;

const int M[] = {
  31, 28, 31, 30, 31, 30, 31,
  31, 30, 31, 30, 31, 30, 31
};

int date_to_index(int dd, int mm) {
  int X = 0;
  REP (i, mm-1) X += M[i];
  X += dd-1;
  return X;
}

pair<int, int> index_to_date(int X) {
  int mm, dd;
  for (mm = 0; X >= M[mm]; X -= M[mm], ++mm);
  dd = X + 1;
  return {dd, mm+1};
}

int main(void) {
  int t, n;
  scanf("%d%d", &t, &n);

  t = t / 100 - n;

  REP (i, n) {
    int dd, mm;
    scanf("%d.%d.", &dd, &mm);

    int d = date_to_index(dd, mm);
    int x = min(t, 364-d);
    t -= x;

    pair<int, int> nd = index_to_date(d+x);
    printf("%02d.%02d.\n", nd.first, nd.second);
  }

  assert(t == 0);

  return 0;
}
